/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class DropTriggerNode
extends DDLStatementNode {
    private TableDescriptor td;

    public String statementToString() {
        return "DROP TRIGGER";
    }

    public QueryTreeNode bind() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        TriggerDescriptor triggerDescriptor = null;
        if (schemaDescriptor.getUUID() != null) {
            triggerDescriptor = dataDictionary.getTriggerDescriptor(this.getRelativeName(), schemaDescriptor);
        }
        if (triggerDescriptor == null) {
            throw StandardException.newException("42X94", (Object)"TRIGGER", (Object)this.getFullName());
        }
        this.td = triggerDescriptor.getTableDescriptor();
        compilerContext.createDependency(this.td);
        compilerContext.createDependency(triggerDescriptor);
        return this;
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropTriggerConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.td.getUUID());
    }
}

